/*----------------------------------------------------------------------*/
/*	                     Shooter     									*/
/*----------------------------------------------------------------------*/
#include	"sgl.h"
//#include	"ss_scrol.h"
#include "../scroll/sora4.cel"
#include "../scroll/sora4.map"
#include "../scroll/sora4.pal"
#include "../scroll/tuti2.cel"
#include "../scroll/tuti2.map"
#include "../scroll/tuti2.pal"

#include	"sega_sys.h"
#include	"space2.cel"
#include	"space2.map"
#include	"space2.pal"

#include    "sl_def.h"
#include    "sddrvs.dat"
#include	"explo8m.h"

#define		RBG0RB_CEL_ADR			(VDP2_VRAM_A0            )
#define		RBG0RB_MAP_ADR			(VDP2_VRAM_B0            )
#define		RBG0RB_COL_ADR			(VDP2_COLRAM    + 0x00200)
#define		RBG0RA_CEL_ADR			(RBG0RB_CEL_ADR + 0x06e80)
#define		RBG0RA_MAP_ADR			(RBG0RB_MAP_ADR + 0x02000)
#define		RBG0RA_COL_ADR			(RBG0RB_COL_ADR + 0x00200)
#define		RBG0_KTB_ADR			(VDP2_VRAM_A1            )
#define		RBG0_PRA_ADR			(VDP2_VRAM_A1   + 0x1fe00)
#define		RBG0_PRB_ADR			(RBG0_PRA_ADR   + 0x80   )
#define		BACK_COL_ADR			(VDP2_VRAM_A1   + 0x1fffe)
#define		PAD_NUM			13

static Uint16 pad_asign[] = {
	PER_DGT_KU,
	PER_DGT_KD,
	PER_DGT_KR,
	PER_DGT_KL,
	PER_DGT_TA,
	PER_DGT_TB,
	PER_DGT_TC,
	PER_DGT_ST,
	PER_DGT_TX,
	PER_DGT_TY,
	PER_DGT_TZ,
	PER_DGT_TR,
	PER_DGT_TL,
};

static	ANGLE	pang[XYZ] = {DEGtoANG(0.0) , DEGtoANG(0.0) , DEGtoANG(0.0)};
static	FIXED	ppos[XYZ] = {toFIXED(0.0) , toFIXED(0.0) , toFIXED(400.0)};
static	FIXED	pscl[XYZ] = {toFIXED(1.0) , toFIXED(1.0) , toFIXED(  1.0)};
static	ANGLE	kang[XYZ];
static	ANGLE	wang[XYZ];
static	FIXED	wpos[XYZ];
static	FIXED	wscl[XYZ];

extern TEXTURE tex_spr[];
extern PICTURE pic_spr[];
extern FIXED stat[][XYZS];
extern SPR_ATTR attr[];
extern ANGLE angz[];

extern char explo8m[];
extern Uint32 explo8m_size;
extern PCM explo8m_dat ;

Sint32 BGposX, BGposY;
int tempo;

/*----------------------------------------------------------------------*/
static void set_sprite(PICTURE *pcptr , Uint32 NbPicture)
{
	TEXTURE *txptr;
 
	for(; NbPicture-- > 0; pcptr++){
		txptr = tex_spr + pcptr->texno;
		slDMACopy((void *)pcptr->pcsrc,
			(void *)(SpriteVRAM + ((txptr->CGadr) << 3)),
			(Uint32)((txptr->Hsize * txptr->Vsize * 4) >> (pcptr->cmode)));
	}
}

/*----------------------------------------------------------------------*/
static void disp_sprite(int SpriteNo)
{
	
	slDispSprite((FIXED *)stat[SpriteNo], (SPR_ATTR *)(&attr[SpriteNo].texno), DEGtoANG(0));
	
}

/*----------------------------------------------------------------------*/
void init_scroll()
{
	slColRAMMode(CRM16_1024);

	slRparaInitSet((void*)RBG0_PRA_ADR);
	slMakeKtable((void*)RBG0_KTB_ADR);
	slCharRbg0(COL_TYPE_256 , CHAR_SIZE_1x1);
	slPageRbg0((void*)RBG0RB_CEL_ADR , 0 , PNB_1WORD|CN_12BIT);
	slPlaneRA(PL_SIZE_1x1);
	sl1MapRA((void*)RBG0RA_MAP_ADR);
	slOverRA(0);
	slKtableRA((void*)RBG0_KTB_ADR , K_FIX | K_DOT | K_2WORD | K_ON);
	//Cel2VRAM(tuti_cel , (void*)RBG0RA_CEL_ADR , 2008*64);
	//Cel2VRAM(back_cel , (void *)RBG0RA_CEL_ADR , 2008*64);   
	//Map2VRAM(tuti_map , (void*)RBG0RA_MAP_ADR , 64 , 64 , 2 , 884);
	//Map2VRAM(back_map , (void *)RBG0RA_MAP_ADR , 64 , 32 , 1 , 256);
	//Pal2CRAM(tuti_pal , (void*)RBG0RA_COL_ADR , 160);

	slPlaneRB(PL_SIZE_1x1);
	sl1MapRB((void*)RBG0RB_MAP_ADR);
	slOverRB(0);
	slKtableRB((void*)RBG0_KTB_ADR , K_FIX | K_DOT | K_2WORD | K_ON);
	Cel2VRAM(space2_cel , (void *)RBG0RB_CEL_ADR , 1919*64);   
	Map2VRAM(space2_map , (void *)RBG0RB_MAP_ADR , 64 , 30 , 1 , 0);
	Pal2CRAM(space2_pal , (void *)RBG0RB_COL_ADR , 256);

	slRparaMode(K_CHANGE);

	slBack1ColSet((void*)BACK_COL_ADR , 0);

	slScrAutoDisp(NBG0ON | RBG0ON);
	slTVOn();
}

/*----------------------------------------------------------------------*/
void disp_scroll()
{
	/* sol */
	/*wpos[X] = ppos[X] / 2.0;
	wpos[Y] = -(ppos[Z] / 2.0);
	wpos[Z] = -(ppos[Y] / 2.0 + pang[X] * 64.0);
	wang[X] =		ppos[Y]/ 16384.0 - (pang[X]/64.0);
	wang[Y] = pang[Y] / 16.0;
	wang[Z] = - (pang[Z] / 20.0);
	slCurRpara(RA);
	slUnitMatrix(CURRENT);
	//slTranslate(toFIXED(0.0)+wpos[X] , toFIXED(0.0)+wpos[Y] , toFIXED(100.0)+wpos[Z]);
	slTranslate(BGposX+wpos[X] , toFIXED(0.0)+wpos[Y] , toFIXED(100.0)+wpos[Z]);
	slRotX(DEGtoANG(-90.0)+wang[X]);
	slRotY(wang[Y]);
	slRotZ(wang[Z]);
	slScrMatSet();*/

	/* ciel */
	wpos[X] = ppos[X] / 20.0;
	//wpos[Y] = ppos[Y] / 20.0 - pang[X] * 12.0;
	wpos[Y] = ppos[Y] / 20.0;
	wpos[Z] = ppos[Z] / 5.0;
	wang[Y] = pang[Y] / 20.0;
	wang[Z] = - (pang[Z] / 20.0);
	slCurRpara(RB);
	slUnitMatrix(CURRENT);
	//slTranslate(BGposX+wpos[X] , toFIXED(150.0)+wpos[Y] , toFIXED(100.0)+wpos[Z]);
	slTranslate(BGposX+wpos[X] , toFIXED(120.0) , toFIXED(100.0)+wpos[Z]);
	//slRotY(wang[Y]);
	//slRotZ(wang[Z]);
	slScrMatSet();
}
/*----------------------------------------------------------------------*/
void init_sound()
{
    char sound_map[] = {0xff , 0xff} ;
    slInitSound(sddrvstsk , sizeof(sddrvstsk) , (Uint8 *)sound_map , sizeof(sound_map)) ;
}
/*----------------------------------------------------------------------*/
void ss_main(void)
{
	Uint16 data;
	PerDigital	*pptr ;
    Sint16	padp ;
	Sint32 posX, posY;
	
	int bullet1, bullet2, MissileEnnemi1, MissileEnnemi2;
	int score;
	int explose, aura, deathwave, deathwavectr;

	slInitSystem(TV_320x224,tex_spr,1);
	init_sound() ;

	set_sprite(pic_spr,29);

	posX = 0;
	posY = 0;
	bullet1 = 0;
	bullet2 = 0;
	MissileEnnemi1 = 0;
	MissileEnnemi2 = 0;
	score = 0;
	explose = 0;
	aura = 0;
	deathwave = 0;
	deathwavectr = 0;

	init_scroll();

	while(1) 
	{
		if(!Per_Connect1) return;
		data = Smpc_Peripheral[0].data;
		pptr = Smpc_Peripheral;
		padp = ~pptr->push;

		if((data & pad_asign[5])==0)			/* si appuie sur B */
		{
			stat[15][0] = stat[0][0];	stat[15][1] = stat[0][1]-toFIXED(20.0);
			stat[16][0] = stat[0][0];	stat[16][1] = stat[0][1]-toFIXED(20.0);
			stat[17][0] = stat[0][0];	stat[17][1] = stat[0][1]-toFIXED(20.0);
			stat[18][0] = stat[0][0];	stat[18][1] = stat[0][1]-toFIXED(20.0);
			stat[19][0] = stat[0][0];	stat[19][1] = stat[0][1]-toFIXED(20.0);

			aura += toFIXED(1.0);
			if(aura <= toFIXED(34.0) & aura >= toFIXED(28.0))
			{
				disp_sprite(15);
			}
			if(aura <= toFIXED(41.0) & aura >= toFIXED(35.0))
			{
				disp_sprite(16);
			}
			if(aura <= toFIXED(48.0) & aura >= toFIXED(42.0))
			{
				disp_sprite(17);
			}
			if(aura <= toFIXED(55.0) & aura >= toFIXED(49.0))
			{
				disp_sprite(18);
			}
			if(aura <= toFIXED(62.0) & aura >= toFIXED(56.0))
			{
				disp_sprite(19);
			}
			if(aura == toFIXED(62))
			{
				aura = 0;
				deathwave = toFIXED(1.0);
			}
			
		}		
		if(((data & pad_asign[0])==0)  )		/* si appuie en haut */
		{
			posY += toFIXED(2.0);
			stat[0][1] -= toFIXED(2.0);		
		}
		
		if(((data & pad_asign[1])==0)  )		/* si appuie en bas */
		{
			posY -= toFIXED(2.0) ;
			stat[0][1] += toFIXED(2.0);		
		}

		if(((data & pad_asign[2])==0)  )		/* si appuie a droite */
		{
			posX += toFIXED(2.0);
			stat[0][0] += toFIXED(2.0);		
		}
		
		if(((data & pad_asign[3])==0)  )		/* si appuie a gauche */
		{
			posX -= toFIXED(2.0);
			stat[0][0] -= toFIXED(2.0);	
		}

		
		if((data & pad_asign[4])==0 )	/* si appuie sur A */
		{
			if(bullet1==0)
			{
				bullet1 = toFIXED(1.0);
				stat[1][0] = posX - toFIXED(92.0);
				stat[1][1] = -posY + toFIXED(30.0);
			}
			else
			{
				if((bullet2==0) & (stat[1][0]>=toFIXED(80.0)) )
				{
					bullet2 = toFIXED(1.0);
					stat[2][0] = posX - toFIXED(92.0);
					stat[2][1] = -posY + toFIXED(30.0);
				}		
			}
		}
		
		if(bullet1==toFIXED(1.0))
		{
			stat[1][0] += toFIXED(5.0);
			if(stat[1][0]>=toFIXED(180.0))
			{
				bullet1 = 0;
				stat[1][1] = toFIXED(-300.0);
			}
		}
		if(bullet2==toFIXED(1.0))
		{
			stat[2][0] += toFIXED(5.0);
			if(stat[2][0]>=toFIXED(180.0))
			{
				bullet2 = 0;
				stat[2][1] = toFIXED(-300.0);
			}
		}
			
		//affichage des symboles
		disp_sprite(0);
		disp_sprite(1);
		disp_sprite(2);
		disp_sprite(3);
		disp_sprite(4);
		disp_sprite(5);
		disp_sprite(13); // missile ennemi
		disp_sprite(14); // missile ennemi
		

		// faire bouger l'avion ennemi
		stat[3][0] -= toFIXED(2.0);	/*   X   */
		stat[3][1] += toFIXED(1.0); /*   Y   */
		if(stat[3][1]==toFIXED(100.0))
		{
			stat[3][0] = toFIXED(150.0);
			stat[3][1] = toFIXED(-80.0); 
		}
		if(stat[3][0]==toFIXED(96.0))
		{
			stat[13][0] = stat[3][0];
			stat[13][1] = stat[3][1];
			MissileEnnemi1 = toFIXED(1.0);
		}
		if(MissileEnnemi1==toFIXED(1.0))
		{
			stat[13][0] -= toFIXED(5.0);
			if(stat[13][0]<=toFIXED(-300.0))
			{
				MissileEnnemi1 = 0;
				stat[13][1] = toFIXED(-300.0);
			}
		}
//-----------------------------------------------------------
		stat[4][0] -= toFIXED(2.0);	/*   X   */
		stat[4][1] += toFIXED(1.0); /*   Y   */
		if(stat[4][1]==toFIXED(140.0))
		{
			stat[4][0] = toFIXED(170.0);
			stat[4][1] = toFIXED(-60.0); 
		}
//-----------------------------------------------------------
		stat[5][0] -= toFIXED(2.0);	/*   X   */
		//stat[5][1] += toFIXED(1.0); /*   Y   */
		if(stat[5][0]==toFIXED(-180.0))
		{
			stat[5][0] = toFIXED(200.0);
			stat[5][1] += toFIXED(15.0); 
			if(stat[5][1]>=toFIXED(140.0))
			{
				stat[5][1] = toFIXED(-50.0);
			}
		}
		if(stat[5][0]==toFIXED(110.0))
		{
			stat[14][0] = stat[5][0];
			stat[14][1] = stat[5][1];
			MissileEnnemi2 = toFIXED(1.0);
		}
		if(MissileEnnemi2==toFIXED(1.0))
		{
			stat[14][0] -= toFIXED(5.0);
			if(stat[14][0]<=toFIXED(-300.0))
			{
				MissileEnnemi2 = 0;
				stat[14][1] = toFIXED(-300.0);
			}
		}
//-----------------------------------------------------------
		//slPrintFX(stat[20][0], slLocate(25,20));
		//slPrintFX(stat[20][1], slLocate(25,22));
		//slPrintFX(stat[5][1]-toFIXED(10.0), slLocate(25,24));
		//slPrintFX(stat[5][1]+toFIXED(10.0), slLocate(25,26));
		//slPrintFX(score, slLocate(25,26));

		
		//  Detection des collisions
		if( ( stat[1][0]>=stat[5][0] & stat[1][0]<=(stat[5][0]+toFIXED(5.0)) ) & (stat[1][1]>=(stat[5][1]-toFIXED(10.0))) & (stat[1][1]<=(stat[5][1]+toFIXED(10.0))) )
		{
			score += toFIXED(1.0);
			stat[6][0] = stat[5][0];
			stat[6][1] = stat[5][1];
			stat[7][0] = stat[5][0];
			stat[7][1] = stat[5][1];
			stat[8][0] = stat[5][0];
			stat[8][1] = stat[5][1];
			stat[9][0] = stat[5][0];
			stat[9][1] = stat[5][1];
			stat[10][0] = stat[5][0];
			stat[10][1] = stat[5][1];
			stat[11][0] = stat[5][0];
			stat[11][1] = stat[5][1];
			stat[12][0] = stat[5][0];
			stat[12][1] = stat[5][1];
			
			explose = toFIXED(1.0);
			tempo = 0;

			bullet1 = 0;
			stat[1][1] = toFIXED(-300.0);
			stat[5][0] = toFIXED(250.0);	/*   efface l'ennemi touche   */
			stat[5][1] += toFIXED(15.0); 

		}
		if(( stat[2][0]>=stat[5][0] & stat[2][0]<=(stat[5][0]+toFIXED(5.0)) ) & (stat[2][1]>=(stat[5][1]-toFIXED(10.0))) & (stat[2][1]<=(stat[5][1]+toFIXED(10.0))) )
		{
			score += toFIXED(1.0);
			stat[6][0] = stat[5][0];
			stat[6][1] = stat[5][1];
			stat[7][0] = stat[5][0];
			stat[7][1] = stat[5][1];
			stat[8][0] = stat[5][0];
			stat[8][1] = stat[5][1];
			stat[9][0] = stat[5][0];
			stat[9][1] = stat[5][1];
			stat[10][0] = stat[5][0];
			stat[10][1] = stat[5][1];
			stat[11][0] = stat[5][0];
			stat[11][1] = stat[5][1];
			stat[12][0] = stat[5][0];
			stat[12][1] = stat[5][1];
			
			explose = toFIXED(1.0);
			tempo = 0;

			bullet2 = 0;
			stat[2][1] = toFIXED(-300.0);
			stat[5][0] = toFIXED(250.0);	/*   efface l'ennemi touche   */
			stat[5][1] += toFIXED(15.0); 
		}


		if(( stat[1][0]>=stat[3][0] & stat[1][0]<=(stat[3][0]+toFIXED(5.0)) ) & (stat[1][1]>=(stat[3][1]-toFIXED(10.0))) & (stat[1][1]<=(stat[3][1]+toFIXED(10.0))) )
		{
			score += toFIXED(1.0);
			stat[6][0] = stat[3][0];
			stat[6][1] = stat[3][1];
			stat[7][0] = stat[3][0];
			stat[7][1] = stat[3][1];
			stat[8][0] = stat[3][0];
			stat[8][1] = stat[3][1];
			stat[9][0] = stat[3][0];
			stat[9][1] = stat[3][1];
			stat[10][0] = stat[3][0];
			stat[10][1] = stat[3][1];
			stat[11][0] = stat[3][0];
			stat[11][1] = stat[3][1];
			stat[12][0] = stat[3][0];
			stat[12][1] = stat[3][1];
			
			explose = toFIXED(1.0);
			tempo = 0;
			bullet1 = 0;
			stat[1][1] = toFIXED(-300.0);
			stat[3][0] = toFIXED(150.0);
			stat[3][1] = toFIXED(-80.0); 
		}
		if(( stat[2][0]>=stat[3][0] & stat[2][0]<=(stat[3][0]+toFIXED(5.0)) ) & (stat[2][1]>=(stat[3][1]-toFIXED(10.0))) & (stat[2][1]<=(stat[3][1]+toFIXED(10.0))) )
		{
			score += toFIXED(1.0);
			stat[6][0] = stat[3][0];
			stat[6][1] = stat[3][1];
			stat[7][0] = stat[3][0];
			stat[7][1] = stat[3][1];
			stat[8][0] = stat[3][0];
			stat[8][1] = stat[3][1];
			stat[9][0] = stat[3][0];
			stat[9][1] = stat[3][1];
			stat[10][0] = stat[3][0];
			stat[10][1] = stat[3][1];
			stat[11][0] = stat[3][0];
			stat[11][1] = stat[3][1];
			stat[12][0] = stat[3][0];
			stat[12][1] = stat[3][1];
			
			explose = toFIXED(1.0);
			tempo = 0;
			bullet2 = 0;
			stat[2][1] = toFIXED(-300.0);
			stat[3][0] = toFIXED(150.0);
			stat[3][1] = toFIXED(-80.0); 
		}


		if(( stat[1][0]>=stat[4][0] & stat[1][0]<=(stat[4][0]+toFIXED(5.0)) ) & (stat[1][1]>=(stat[4][1]-toFIXED(10.0))) & (stat[1][1]<=(stat[4][1]+toFIXED(10.0))) )
		{
			score += toFIXED(1.0);
			stat[6][0] = stat[4][0];
			stat[6][1] = stat[4][1];
			stat[7][0] = stat[4][0];
			stat[7][1] = stat[4][1];
			stat[8][0] = stat[4][0];
			stat[8][1] = stat[4][1];
			stat[9][0] = stat[4][0];
			stat[9][1] = stat[4][1];
			stat[10][0] = stat[4][0];
			stat[10][1] = stat[4][1];
			stat[11][0] = stat[4][0];
			stat[11][1] = stat[4][1];
			stat[12][0] = stat[4][0];
			stat[12][1] = stat[4][1];
			
			explose = toFIXED(1.0);
			tempo = 0;
			bullet1 = 0;
			stat[1][1] = toFIXED(-300.0);
			stat[4][0] = toFIXED(170.0);
			stat[4][1] = toFIXED(-60.0);  
		}
		if(( stat[2][0]>=stat[4][0] & stat[2][0]<=(stat[4][0]+toFIXED(5.0)) ) & (stat[2][1]>=(stat[4][1]-toFIXED(10.0))) & (stat[2][1]<=(stat[4][1]+toFIXED(10.0))) )
		{
			score += toFIXED(1.0);
			stat[6][0] = stat[4][0];
			stat[6][1] = stat[4][1];
			stat[7][0] = stat[4][0];
			stat[7][1] = stat[4][1];
			stat[8][0] = stat[4][0];
			stat[8][1] = stat[4][1];
			stat[9][0] = stat[4][0];
			stat[9][1] = stat[4][1];
			stat[10][0] = stat[4][0];
			stat[10][1] = stat[4][1];
			stat[11][0] = stat[4][0];
			stat[11][1] = stat[4][1];
			stat[12][0] = stat[4][0];
			stat[12][1] = stat[4][1];
			
			explose = toFIXED(1.0);
			tempo = 0;
			bullet2 = 0;
			stat[2][1] = toFIXED(-300.0);
			stat[4][0] = toFIXED(170.0);
			stat[4][1] = toFIXED(-60.0);  
		}

		if(explose==toFIXED(1.0))
		{
			tempo += toFIXED(1.0);
			slPCMOn(&explo8m_dat , explo8m , EXPLO8M_LEN ) ;
			if(tempo <= toFIXED(3.0))
			{
				disp_sprite(6);
			}
			if(tempo <= toFIXED(7.0) & tempo >= toFIXED(4.0))
			{
				disp_sprite(7);
			}
			if(tempo <= toFIXED(11.0) & tempo >= toFIXED(8.0))
			{
				disp_sprite(8);
			}
			if(tempo <= toFIXED(16.0) & tempo >= toFIXED(12.0))
			{
				disp_sprite(9);
			}
			if(tempo <= toFIXED(21.0) & tempo >= toFIXED(17.0))
			{
				disp_sprite(10);
			}
			if(tempo <= toFIXED(25.0) & tempo >= toFIXED(22.0))
			{
				disp_sprite(11);
			}
			if(tempo <= toFIXED(29.0) & tempo >= toFIXED(26.0))
			{
				disp_sprite(12);
			}
			if(tempo == toFIXED(29))
			{
				tempo = 0;
				explose = 0;
			}
		}
		if(deathwave==toFIXED(1.0))
		{
			deathwavectr += toFIXED(1.0);
			stat[20][0] += toFIXED(6.0);
			stat[21][0] = stat[20][0];
			stat[22][0] = stat[20][0];
			stat[23][0] = stat[20][0];
			stat[24][0] = stat[20][0];
			stat[25][0] = stat[20][0];
			stat[26][0] = stat[20][0];
			stat[27][0] = stat[20][0];
			stat[28][0] = stat[20][0];

			if(deathwavectr <= toFIXED(4.0))
			{
				disp_sprite(20);
			}
			if(deathwavectr <= toFIXED(9.0) & deathwavectr >= toFIXED(5.0))
			{
				disp_sprite(21);
			}
			if(deathwavectr <= toFIXED(13.0) & deathwavectr >= toFIXED(10.0))
			{
				disp_sprite(22);
			}
			if(deathwavectr <= toFIXED(18.0) & deathwavectr >= toFIXED(14.0))
			{
				disp_sprite(23);
			}
			if(deathwavectr <= toFIXED(23.0) & deathwavectr >= toFIXED(19.0))
			{
				disp_sprite(24);
			}
			if(deathwavectr <= toFIXED(27.0) & deathwavectr >= toFIXED(24.0))
			{
				disp_sprite(25);
			}
			if(deathwavectr <= toFIXED(31.0) & deathwavectr >= toFIXED(28.0))
			{
				disp_sprite(26);
			}
			if(deathwavectr <= toFIXED(35.0) & deathwavectr >= toFIXED(32.0))
			{
				disp_sprite(27);
			}
			if(deathwavectr <= toFIXED(39.0) & deathwavectr >= toFIXED(36.0))
			{
				disp_sprite(28);
			}
			if(deathwavectr == toFIXED(39))
			{
				deathwavectr = 0;
				deathwave = 0;
				stat[20][0] = toFIXED(-128);
				stat[21][0] = stat[20][0];
				stat[22][0] = stat[20][0];
				stat[23][0] = stat[20][0];
				stat[24][0] = stat[20][0];
				stat[25][0] = stat[20][0];
				stat[26][0] = stat[20][0];
				stat[27][0] = stat[20][0];
				stat[28][0] = stat[20][0];
			}

		}

		//  Mouvement du scrolling
		slScrPosNbg1(BGposX , BGposY);
		BGposX += toFIXED(3.0);

		disp_scroll();

		slSynch();
	} 
}

/*----------------------------------------------------------------------*/
void EnnemiExplose()
{
	//tempo += toFIXED(1.0);
	slPCMOn(&explo8m_dat , explo8m , EXPLO8M_LEN ) ;
	if(tempo <= toFIXED(3.0))
	{
		disp_sprite(6);
	}
	if(tempo <= toFIXED(7.0) & tempo >= toFIXED(4.0))
	{
		disp_sprite(7);
	}
	if(tempo <= toFIXED(11.0) & tempo >= toFIXED(8.0))
	{
		disp_sprite(8);
	}
	if(tempo <= toFIXED(16.0) & tempo >= toFIXED(12.0))
	{
		disp_sprite(9);
	}
	if(tempo <= toFIXED(21.0) & tempo >= toFIXED(17.0))
	{
		disp_sprite(10);
	}
	if(tempo <= toFIXED(25.0) & tempo >= toFIXED(22.0))
	{
		disp_sprite(11);
	}
	if(tempo <= toFIXED(29.0) & tempo >= toFIXED(26.0))
	{
		disp_sprite(12);
	}
	if(tempo == toFIXED(29))
	{
		tempo = 0;
	}
}