/*
 * 8-bit Bitmap Demo
 * Bart Trzynadlowski
 * May 2, 2001 (updated June 18, 2001)
 * Public domain
 */

/*
 * bmp8bpp.c: The main program code. If you wish to change the image, simply
 * replace image_data[] and image_pal[] (in image.h) with new data. Be sure to
 * change IMAGE_XSIZE and IMAGE_YSIZE to suit the new image. Try to keep the
 * image 320x224 pixels or less.
 *
 * Use bmp2raw (http://trzy.overclocked.org) to convert 256-color BMP files
 * to raw data. Then, use bin2c (http://trzy.overclocked.org) to convert the
 * resulting .raw and .555 files into image_data[] and image_pal[] arrays in
 * image.h.
 *
 * To compile this demo, you will need an SH-2-targeted gcc. I used gcc
 * version cygnus-2.7-96q3. You should have received a file called bmp8bpp.bin,
 * a ready-to-run binary. You can execute this code on a PAR, but make sure to
 * load it at 0x6004000.
 */

#include "image.h"  /* image data */


void SetPal1024(unsigned char *pal, int colors)
{
    int             i;
    unsigned short  *cram = (unsigned short *) 0x5f00000;

    /*
     * RGB-5 1024-color palette
     */

    *((unsigned short *) 0x5f8000e) = *((unsigned short *) 0x5f8000e) & (~0x3000);

    /*
     * Load the color data into VDP2 color RAM
     */

    for (i = 0; i < colors; i++)
        cram[i] = (pal[i*2] << 8) | pal[i*2+1];
}
    
void _main()
{
    unsigned char   *bmp = (unsigned char *) 0x5e00000;
    int             i, j, x, y;

    SetPal1024(image_pal, sizeof(image_pal) / 2);

    /*
     * Map Offset Register: Bitmap screen will be located at VRAM offset 0
     */

    *((unsigned short *) 0x5f8003c) = 0;

    /*
     * Character Control Register: 256 colors, enable NBG0 as a bitmap
     */

    *((unsigned short *) 0x5f80028) = 0x12;

    /*
     * Screen Scroll Value Registers: No scroll
     */

    *((unsigned short *) 0x5f80070) = 0;
    *((unsigned short *) 0x5f80072) = 0;
    *((unsigned short *) 0x5f80074) = 0;

    /*
     * Screen Display Enable Register: Invalidate the transparency code for
     * NBG0 and display NBG0
     */

    *((unsigned short *) 0x5f80020) = 0x101;

    /*
     * Fill the screen with color 0 of the image
     */

    for (i = 0; i < 512*512; i++)
        bmp[i] = 0;

    i = ((320 - IMAGE_XSIZE) / 2) + ((224 - IMAGE_YSIZE) / 2) * 320;
    j = 0;
    for (y = 0; y < IMAGE_YSIZE; y++)
    {
        for (x = 0; x < IMAGE_XSIZE; x++)
        {
            bmp[i] = image_data[j];
            j++;
            i++;
        }
        i += 512-IMAGE_XSIZE;   /* bitmap screen width is 512 pixels */
    }
}
